
%% "Encoding words into interval type-2 fuzzy sets using an interval
%%  approach"  Feilong Liu and Jerry M. Mendel
%%  Programed by Feilong Liu
%%  Modified by Jhiin Joo

%%	 << Purpose >>
%%	    Generate interval type-2 word models for words 

%   << Internal Functions called by main.m >>
%%		Fuzzistics.m  : This program is coded by Feilong Liu
%%		centroid.m	  : This program is called from software on Mendel's website. 
		
%%		For the details of each function, see a comment in each 
%%		MATLAB (*.m) file.


function [words_DR, MFs, Cs, Cl, Cr]=getFOUs_FLIA_weight(ppmenu61string)

%% -- Read Data------------------------------
W = xlsread('data_thirdpart_Left.xls'); %% read the data from the first part of the survey
[row, col] = size(W);

%% --- Input the names of words --------------
ppmenu61string; %% Words that we will use for the third part of the Survey
MFs=zeros(col/2,9);

%% ---- compute the FOUs and centroids --------------------
for i=1:col/2
     L = W(1:row, 2*i-1);  %%Read the left end points for interval data.
    R = W(1:row, 2*i);    %%Read the right end points for interval data.
    [MFs(i,:),n(i),Stat, NNum, Shift(i,:)] = Fuzzistics_FL1(L,R); %%Determine the interval type-2 MFs and the number of remaining interval data m* for each word.
   [Cs(i), Cl(i), Cr(i)]=centroid(MFs(i,:)); %%Compute the center of the centroid and the centroid of interval type-2 MFs.
end

%% -- sort the MFs in ascending order according to the center of centroid --
[Cs,index]=sort(Cs);  %% Sort the center of the centroid
MFs=MFs(index,:);     %% Reorder the MFs based on the sorting of the center of centroids
Cl=Cl(index);         %% Reorder the left end of the centroid.
Cr=Cr(index);         %% Reorder the right end of the centroid.
words_DR=ppmenu61string(index,:); %%Reorder the names of words.

